#!/usr/bin/perl

# version 01, last updated 10 Apr 2022

$name=$ARGV[0]; $inp=$ARGV[1];

open(INP, "<$inp"); $i=0;
while(<INP>) {chomp; @f=split /\t/;
   $i++; $fte[$i]=$f[0]; $tf[$i]=$f[1]}
close(INP); $n=$i;

# define output file name, layout, invariable plot parameters
#
print "pdf(file=\"$name\_motif_enr.pdf\", width=7, height=10, paper=\"a4\")\n";
print "par(mfrow=c(4,2))\n";
print "par(mar=c(5,5,4,1))\n";

print "ylab=\"Fold enrichment\"\n";

# major loop over samples

while(<STDIN>) {@f=split /\t/; 

   $sample=$f[0]; $sample =~ s/.sga$//;
   $exp=$f[1]; $exp =~ s/\|/ | /g;

# minor loop over target motifs

   for($i=1; $i<=$n; $i++) {if($f[2] eq $fte[$i] and $f[4] eq "T") {
      print "xlab=\"Position relative to $tf[$i] motif\"\n";

# edit shell code 

$command = <<CMD;

exp="$exp"
legend=c("5'tags","3'tags")
col=c("green2","red2")

xf=read.table("results/$sample\_$tf[$i]_f.tsv")[,1]
yf=read.table("results/$sample\_$tf[$i]_f.tsv")[,2]*2
xr=read.table("results/$sample\_$tf[$i]_r.tsv")[,1]
yr=read.table("results/$sample\_$tf[$i]_r.tsv")[,2]*2

ylim=c(0.0,1.1*max(10,yf,yr))
plot(xf,yf,type="l",ylim=ylim, col=col[1], main=exp, xlab=xlab,
ylab=ylab, cex.main=1.3, cex.lab=1.4, cex.axis=1.4)
par(new=T)
plot(xr,yr,type="l",ylim=ylim, col=col[2], main="", xlab="",
ylab="", xaxt="n", yaxt="n")
legend("topleft",legend=legend,col=col, bty="n", lty=1, cex=1.4)

CMD
   print $command;
   }}}

print "dev.off();\n"
