#!/usr/local/bin/perl

$pid=$$;
$bowtie_s="bowtie --best --strata --no-unal -m1 --sam -l 50 -n 2 -p 4 --chunkmbs 1000";
$bowtie_p="bowtie --best --strata --no-unal -m1 --sam -l 50 -n 2 -X 1000 -p 4 --chunkmbs 1000";
$ebwt="/home/local/db/bowtie/h_sapiens_hg19";

while(<STDIN>) {chomp; @f=split /\t/; 
   @SRR = split /,/, $f[3]; $name="$f[0]"; $fte=$f[4];
#  @SRR = split /,/, $f[3]; $name="$f[0]\_test"; $fte=$f[4];
   foreach $srr (@SRR) { 

$command = <<CMD;
  fastq-dump --split-e $srr > /dev/null
# fastq-dump -X 100000 --split-e $srr > /dev/null
if [ -f "$srr\_1.fastq" ]; then
   echo "$srr (paired)" >> bowtie_$pid.output
   $bowtie_p $ebwt  -1 $srr\_1.fastq -2 $srr\_2.fastq > $srr.sam 2>> bowtie_$pid.output

   samtools view -bS -o $srr.bam $srr.sam 2> /dev/null
   bamToBed -bedpe -i $srr.bam > $srr.bed
   cat $srr.bed | awk '{FS=OFS="\t"; print \$1,\$2,\$6,\$7,\$6-\$2,\$9}' \\
    | sed 's/^[^ ]*|//g'| bed2sga -s hg19 -f $fte -r | sort -T . -s -k1,1 -k3,3n -k4,4 \\
    | compactsga > $srr.sga 
else
   echo "$srr (single)">> bowtie\_$pid.output
   $bowtie_s $ebwt  $srr.fastq > $srr.sam 2>> bowtie\_$pid.output

   samtools view -bS -o $srr.bam $srr.sam 2> /dev/null
   bamToBed -i $srr.bam > $srr.bed
   cat $srr.bed | sed 's/^[^ ]*|//g'| bed2sga -s hg19 -f $fte | sort -T . -s -k1,1 -k3,3n -k4,4 | compactsga > $srr.sga 
fi

if [ -f $name.sga ]; then
   mv $name.sga $name\_temp.sga
   sort -T. -s -k1,1 -k3,3n -k4,4 $srr.sga $name\_temp.sga | compactsga > $name.sga
else
   mv $srr.sga $name.sga;
fi
   rm $srr*

CMD

print $command;

} 
print "\nmv $name.sga ../$name.sga\n"; 
print "gzip -c ../$name.sga > ../$name.sga.gz\n"; 
print "rm $name\_temp.sga 2> /dev/null\n\n";
}

