#!/usr/bin/perl
#

$dir=$ARGV[0]; 

$rmsk="/home/local/db/mga/hg19/rmsk/rmsk_hg19.SGA";

while(<STDIN>) {@f=split /\t/; $fte=$f[2]; $skip=0;
   if   ($fte eq "ESR1")     {$reference="/export/data/mga/hg19/JasparCore2016vert-000001/genomic_hit_MA0112.3_ESR1.sga"}
   elsif($fte eq "AR")   {$reference="/export/data/mga/hg19/JasparCore2014-000001/genomic_hit_MA0007.2_AR.sga"}
   elsif($fte eq "FOXA1")  {$reference="/export/data/mga/hg19/JasparCore2014-000001/genomic_hit_MA0148.3_FOXA1.sga"}
   else{$skip=1}

   if( $skip) {} else {
   $target="$dir/$f[0]";
   $sample=$f[0]; $sample =~ s/.sga$//;
   $FTE=$fte;

$command = <<CMD;
# --- Sample: $sample

# extract top 1000 peaks with motif

sort -s -m -k1,1 -k3,3n $reference $rmsk | counts_filter > ref_masked.sga
chipcenter -z -s 75  -r TRG -c 10 $target 2>/dev/null > trg_centered.sga
sort -s -m -k1,1 -k3,3n -k4,4 ref_masked.sga trg_centered.sga | compactsga > ref_trg.sga
chipscore -o -A $FTE -B TRG -b -100 -e 100 -t 0 ref_trg.sga 2>/dev/null \\
 | sort -k6,6nr | head -1000 | sort -k1,1 -k3,3n -k4,4 > peaks.sga

# generating aggregation plots

featreplace -f TRG $target > trg.sga
sort -s -m -k1,1 -k3,3n -k4,4 peaks.sga trg.sga > ref_trg.sga
chipcor -o -A "$FTE" -B "TRG +" -b -1000 -e 1000 -w 20 -c 10 -n 2 ref_trg.sga  2>/dev/null > results/$sample\_$FTE\_f.txt
chipcor -o -A "$FTE" -B "TRG -" -b -1000 -e 1000 -w 20 -c 10 -n 2 ref_trg.sga  2>/dev/null > results/$sample\_$FTE\_r.txt
# rm *.sga
CMD

   print $command}
   }
