#!/usr/bin/perl
#

print "pdf(file=\"singhal16_motif_enr.pdf\", width=7, height=10, paper=\"a4\")\n";
print "par(mfrow=c(4,2))\n";
print "par(mar=c(5,5,4,1))\n";

print "ylab=\"Fold enrichment\"\n";

while(<STDIN>) {@f=split /\t/; $fte=$f[2];

   if($fte ne "Feature" and $fte ne "Input") {
   
   if   ($fte eq "ESR1")     {$FTE="ESR1"}
   elsif($fte eq "PGR")      {$FTE="NR3C1"}
   elsif($fte eq "ESR1_IgG") {$FTE="ESR1"}
   elsif($fte eq "ESR1_PGR") {$FTE="ESR1"}

   $exp=$f[1]; $exp =~ s/\|/ | /g;
   $sample=$f[0]; $sample =~ s/.sga$//;

print "xlab=\"Position relative to $FTE motif\"\n";
$command = <<CMD;

exp="$exp"
legend=c("5'tags","3'tags")
col=c("green2","red2")

xf=read.table("results/$sample\_$FTE\_f.txt")[,1]
yf=read.table("results/$sample\_$FTE\_f.txt")[,2]*2
xr=read.table("results/$sample\_$FTE\_r.txt")[,1]
yr=read.table("results/$sample\_$FTE\_r.txt")[,2]*2

ylim=c(0.0,1.1*max(10,yf,yr))
plot(xf,yf,type="l",ylim=ylim, col=col[1], main=exp, xlab=xlab,
ylab=ylab, cex.main=1.3, cex.lab=1.4, cex.axis=1.4)
par(new=T)
plot(xr,yr,type="l",ylim=ylim, col=col[2], main="", xlab="",
ylab="", xaxt="n", yaxt="n")
legend("topleft",legend=legend,col=col, bty="n", lty=1, cex=1.4)

CMD
   print $command;

   if($fte eq "ESR1_PGR") {$FTE="NR3C1";
   print "xlab=\"Position relative to $FTE motif\"\n";

$command = <<CMD;

exp="$exp"
legend=c("5'tags","3'tags")
col=c("green2","red2")

xf=read.table("results/$sample\_$FTE\_f.txt")[,1]
yf=read.table("results/$sample\_$FTE\_f.txt")[,2]*2
xr=read.table("results/$sample\_$FTE\_r.txt")[,1]
yr=read.table("results/$sample\_$FTE\_r.txt")[,2]*2

ylim=c(0.0,1.1*max(10,yf,yr))
plot(xf,yf,type="l",ylim=ylim, col=col[1], main=exp, xlab=xlab,
ylab=ylab, cex.main=1.3, cex.lab=1.4, cex.axis=1.4)
par(new=T)
plot(xr,yr,type="l",ylim=ylim, col=col[2], main="", xlab="",
ylab="", xaxt="n", yaxt="n")
legend("topleft",legend=legend,col=col, bty="n", lty=1, cex=1.4)

CMD
   print $command;
   }}}
print "dev.off();\n"
