#!/usr/bin/perl

print "pdf(file=\"singhal16_strand_cor.pdf\", width=7, height=10, paper=\"a4\")\n";
print "par(mfrow=c(4,2))\n";
print "par(mar=c(5,5,4,1))\n";
print "xlab=\"Position relative to 5'tag\"\n";
print "ylab=\"Fold enrichment\"\n\n";

while(<STDIN>){@f=split /\t/;
   $fname=$f[0]; $fname =~ s/.sga/_strand_cor.txt/;
   $exp=$f[1]; $exp =~ s/\|/ | /g;
   $fte=$f[2];
   if($fte ne "Feature" and $fte ne "ATACseq") {

   print "x=read.table(\"results/$fname\")[,1]\n";
   print "y=read.table(\"results/$fname\")[,2]\n";
   print "exp=\"$exp\"\n";
   print "fte=\"3'tag\"\n";
   print "ylim=c(1,1.2*max(y))\n";
   print "plot(x,y,type=\"l\",ylim=ylim, main=exp, xlab=xlab,\n"; 
   print "ylab=ylab, cex.main=1.2, cex.lab=1.5, cex.axis=1.5)\n";
   print "legend(\"topleft\",legend=c(fte),bty=\"n\", lty=1, cex=1.5)\n\n";
   }}

print "dev.off()\n";
