#!/usr/bin/perl
#

$dir=$ARGV[0]; 

$reference="/home/local/db/mga/hg19/JasparCore2014-000001/genomic_hit_MA0112.2_ESR1.sga";
$rmsk="/export/data//mga/hg19/rmsk/rmsk_hg19.SGA";

while(<STDIN>) {@f=split /\t/; $fte=$f[2]; $skip=0;

   $sample=$f[0]; $sample =~ s/.sga$//;
   if   ($fte eq "ESR1")     {$FTE="ESR1";
     $reference="/home/local/db/mga/hg19/JasparCore2014-000001/genomic_hit_MA0112.2_ESR1.sga"} 
   elsif($fte eq "PGR")      {$FTE="NR3C1"; 
     $reference="/home/local/db/mga/hg19/JasparCore2016vert-000001/genomic_hit_MA0113.3_NR3C1.sga"}
   elsif($fte eq "ESR1_IgG") {$FTE="ESR1"; 
     $reference="/home/local/db/mga/hg19/JasparCore2014-000001/genomic_hit_MA0112.2_ESR1.sga"} 
   elsif($fte eq "ESR1_PGR") {$FTE="ESR1"; 
     $reference="/home/local/db/mga/hg19/JasparCore2014-000001/genomic_hit_MA0112.2_ESR1.sga"} 
   else {$skip=1}
   $target="$dir/$f[0]";

   if($skip) {} else {

$command = <<CMD;
# --- Sample: $sample

# extract top 1000 peaks with motif

sort -s -m -k1,1 -k3,3n $reference $rmsk | counts_filter > ref_masked.sga
chipcenter -z -s 75  -r TRG -c 10 $target 2>/dev/null > trg_centered.sga
sort -s -m -k1,1 -k3,3n -k4,4 ref_masked.sga trg_centered.sga | compactsga > ref_trg.sga
chipscore -o -A $FTE -B TRG -b -100 -e 100 -t 0 ref_trg.sga 2>/dev/null \\
 | sort -k6,6nr | head -1000 | sort -k1,1 -k3,3n -k4,4 > peaks.sga

# generating aggregation plots

featreplace -f TRG $target > trg.sga
sort -s -m -k1,1 -k3,3n -k4,4 peaks.sga trg.sga > ref_trg.sga
chipcor -o -A "$FTE" -B "TRG +" -b -1000 -e 1000 -w 20 -c 10 -n 2 ref_trg.sga  2>/dev/null > results/$sample\_$FTE\_f.txt
chipcor -o -A "$FTE" -B "TRG -" -b -1000 -e 1000 -w 20 -c 10 -n 2 ref_trg.sga  2>/dev/null > results/$sample\_$FTE\_r.txt
# rm *.sga
CMD

   print $command}

   if($skip) {}  elsif($fte eq "ESR1_PGR") {$FTE="NR3C1"; 
   $reference="/home/local/db/mga/hg19/JasparCore2016vert-000001/genomic_hit_MA0113.3_NR3C1.sga";

# A second plot will be generated if feature ESR1_PGR (reChIP-seq for ESR1 and PGR)

$command = <<CMD;

# extract top 1000 peaks with motif

sort -s -m -k1,1 -k3,3n $reference $rmsk | counts_filter > ref_masked.sga
chipcenter -z -s 75  -r TRG -c 10 $target 2>/dev/null > trg_centered.sga
sort -s -m -k1,1 -k3,3n -k4,4 ref_masked.sga trg_centered.sga | compactsga > ref_trg.sga
chipscore -o -A $FTE -B TRG -b -100 -e 100 -t 0 ref_trg.sga 2>/dev/null \\
 | sort -k6,6nr | head -1000 | sort -k1,1 -k3,3n -k4,4 > peaks.sga

# generating aggregation plots

featreplace -f TRG $target > trg.sga
sort -s -m -k1,1 -k3,3n -k4,4 peaks.sga trg.sga > ref_trg.sga
chipcor -o -A "$FTE" -B "TRG +" -b -1000 -e 1000 -w 20 -c 10 -n 2 ref_trg.sga  2>/dev/null > results/$sample\_$FTE\_f.txt
chipcor -o -A "$FTE" -B "TRG -" -b -1000 -e 1000 -w 20 -c 10 -n 2 ref_trg.sga  2>/dev/null > results/$sample\_$FTE\_r.txt
# rm *.sga
CMD

   print $command}
   }
